function [logL,lik]=TCopCVineLL(phi,data,optimizer)
% The log likelihood of a Canonical Vine, assuming T - Copula for all pairs
% INPUTS:
% phi:          A column vector of parameters for the copulas, of size
%               N(N-1)/2, where N are the columns of data
% data:         A TxN matrix of U(0,1) or iid margins. If you supply iid
%               margins (eg the residuals from some GARCH filtration),
%               these are transformed to uniform via the empiricalCDF
%               function
% OUTPUTS:
% logL:         The negative log likelihood of the Vine
% lik:          The log likelihoods from each paired T - Copula
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if nargin==2
    optimizer='fmincon';
end
if min(min(data))<0 || max(max(data))>1
    data=empiricalCDF(data);
end
[T,N]=size(data);
lik=zeros(N-1,N-1);
u=cell(N,N);
if size(phi,1)~=N*(N-1)/2 || size(phi,2)~=1
    if size(phi,1)==N-1 && size(phi,2)==N-1
    phi=icrIPmat(phi);
    elseif size(phi,2)==N*(N-1)/2 && size(phi,1)==1
    phi=phi';
    else
    error('phi is a column vector with N(N-1)/2 rows, or a square matrix with N-1 rows')
    end
end
phi=crIPmat(phi); theta=zeros(size(phi));
for j=1:N-1
   for i=1:N-j
       if j==1
       [lik(j,i), theta(j,i)]=StaticTCopulaLL(phi(j,i),[data(:,1),data(:,i+1)],optimizer);
       else
       [lik(j,i), theta(j,i)]=StaticTCopulaLL(phi(j,i),[u{j-1,1},u{j-1,i+1}],optimizer);
       end
   end
   if j<N-1
       for i=1:N-j
       if j==1
       rho=corr([data(:,i+1), data(:,1)],'type','Kendall');
       rho=sin(.5*pi*rho(1,2));
       u{1,i}=hfuncTC(data(:,i+1),data(:,1),theta(1,i),rho);
       else
       rho=corr([u{j-1,i+1} u{j-1,1}],'type','Kendall'); 
       rho=sin(.5*pi*rho(1,2));
       u{j,i}=hfuncTC(u{j-1,i+1},u{j-1,1},theta(j,i),rho);
       end
       end
   end
end
logL=sum(sum(lik));
